/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility.POSPrinter.Star;

import com.starmicronics.utility.BaseTextMagnification;
import com.starmicronics.utility.POSPrinter.BitmapConverter;
import com.starmicronics.utility.POSPrinter.MapModeConversion;
import com.starmicronics.utility.POSPrinter.PrinterFont;
import com.starmicronics.utility.POSPrinter.Star.BarcodeWidth;
import com.starmicronics.utility.POSPrinter.Star.CommandStar;
import com.starmicronics.utility.ParsedJposEntry;
import com.starmicronics.utility.PrintResolution;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import jpos.JposException;
import jpos.config.JposEntry;

public class CommandStarThermal
extends CommandStar {
    private boolean m_isStarPRNT = false;
    private boolean m_capRecFullCut = false;
    private boolean m_capRecPartialCut = false;
    private byte m_multipleHeightCommand = 0;
    private byte m_multipleWidthCommand = 0;
    private MapModeConversion m_mapMode;
    private PrintResolution m_printResolution = PrintResolution.ResolutionNotSpecified;

    public CommandStarThermal(PrinterFont printerFont, MapModeConversion mapModeConversion, JposEntry jposEntry) {
        super(printerFont, jposEntry);
        if (jposEntry.hasPropertyWithName("StarPRNT")) {
            this.m_isStarPRNT = (Boolean)jposEntry.getPropertyValue("StarPRNT");
        }
        this.m_mapMode = mapModeConversion;
        this.m_capRecPartialCut = (Boolean)jposEntry.getPropertyValue("partialCut");
        this.m_capRecFullCut = (Boolean)jposEntry.getPropertyValue("fullCut");
        ParsedJposEntry parsedJposEntry = new ParsedJposEntry(jposEntry);
        this.m_printResolution = parsedJposEntry.getPrintResolution();
        switch (this.m_printResolution) {
            case Resolution300dpi: {
                this.m_maxQrCodeCellSize = 12;
                break;
            }
            default: {
                this.m_maxQrCodeCellSize = 8;
            }
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417Line") && Integer.class == jposEntry.getPropertyType("PDF417Line")) {
                this.setPdf417Line((Integer)jposEntry.getPropertyValue("PDF417Line"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417Column") && Integer.class == jposEntry.getPropertyType("PDF417Column")) {
                this.setPdf417Column((Integer)jposEntry.getPropertyValue("PDF417Column"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417Ecc") && Integer.class == jposEntry.getPropertyType("PDF417Ecc")) {
                this.setPdf417Ecc((Integer)jposEntry.getPropertyValue("PDF417Ecc"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417ModuleXdim") && Integer.class == jposEntry.getPropertyType("PDF417ModuleXdim")) {
                this.setPdf417ModuleXdim((Integer)jposEntry.getPropertyValue("PDF417ModuleXdim"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417Aspect") && Integer.class == jposEntry.getPropertyType("PDF417Aspect")) {
                this.setPdf417Aspect((Integer)jposEntry.getPropertyValue("PDF417Aspect"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("QRCodeModel") && Integer.class == jposEntry.getPropertyType("QRCodeModel")) {
                this.setQrCodeModel((Integer)jposEntry.getPropertyValue("QRCodeModel"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("QRCodeEcc") && Integer.class == jposEntry.getPropertyType("QRCodeEcc")) {
                this.setQrCodeEcc((Integer)jposEntry.getPropertyValue("QRCodeEcc"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("QRCodeCellSize") && Integer.class == jposEntry.getPropertyType("QRCodeCellSize")) {
                this.setQrCodeCellSize((Integer)jposEntry.getPropertyValue("QRCodeCellSize"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List initializeCommand() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(new byte[]{27, 29, 116, this.m_printerFont.getCharacterSetByteCommand()});
        if (this.m_printerFont.getCapFontB()) {
            arrayList.add(new byte[]{27, 30, 70, this.m_printerFont.getFontSelect()});
        }
        arrayList.add(new byte[]{27, 32, this.m_printerFont.getRightSideCharacterSpacing()});
        if (this.m_printerFont.getDotLineSpacingNarrow() == this.m_printerFont.getDotLineSpacing()) {
            arrayList.add(new byte[]{27, 122, 48});
        } else {
            arrayList.add(new byte[]{27, 122, 49});
        }
        arrayList.add(new byte[]{27, 70});
        arrayList.add(new byte[]{27, 45, 48});
        arrayList.add(new byte[]{27, 53});
        arrayList.add(new byte[]{27, 87, 48});
        arrayList.add(new byte[]{27, 104, 48});
        arrayList.add(new byte[]{27, 29, 97, 48});
        HashMap<BaseTextMagnification, Byte> hashMap = new HashMap<BaseTextMagnification, Byte>(){
            {
                this.put(BaseTextMagnification.Standard, (byte)0);
                this.put(BaseTextMagnification.X1_5, (byte)1);
            }
        };
        if (hashMap.containsKey((Object)this.m_printerFont.getBaseTextMagnification())) {
            arrayList.add(new byte[]{27, 29, 41, 69, 2, 0, 48, (Byte)hashMap.get((Object)this.m_printerFont.getBaseTextMagnification())});
        }
        return arrayList;
    }

    @Override
    public List barCodeCommand(String string, int n, int n2, int n3, int n4, int n5) throws JposException {
        int n6;
        int n7;
        int n8;
        byte by;
        int n9;
        Object object;
        int n10;
        int n11 = 0;
        int n12 = 0;
        byte[] byArray = null;
        Object object2 = string.getBytes();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        switch (n) {
            case 201: 
            case 204: {
                n5 = -11;
                n2 = 1;
            }
        }
        if (-11 == n5) {
            n10 = 49;
        } else if (-13 == n5) {
            n10 = 50;
        } else {
            throw new JposException(106, "This request failed because the specified text placement is not supported.");
        }
        if (1 > n2 || 255 < n2) {
            throw new JposException(106, "This request failed because the specified height is not supported.");
        }
        if (n3 < 1 || n3 > this.m_printerFont.getLineWidthDot()) {
            throw new JposException(106, "This request failed because the specified width is not supported.");
        }
        if (0 > this.m_printerFont.getLineWidthDot() - n4 - n3) {
            throw new JposException(106, "This request failed because the specified alignment is not supported.");
        }
        if (123 == n || 110 == n) {
            if (((byte[])object2).length < 1 || ((byte[])object2).length > 255) {
                throw new JposException(106);
            }
            object = null;
            n9 = 0;
            n11 = 54;
            n12 = 49;
            for (int i = 0; i < 2; ++i) {
                by = 0;
                for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                    byte by2 = object2[n8];
                    if (by == 0) {
                        if (by2 == 123) {
                            by = 1;
                            continue;
                        }
                        if (by2 < 0 || by2 > 127) {
                            throw new JposException(106);
                        }
                        if (by2 >= 0 && by2 <= 31) {
                            if (null != object) {
                                object[n9] = 37;
                            }
                            ++n9;
                            if (null != object) {
                                object[n9] = (byte)(64 + by2);
                            }
                            ++n9;
                            continue;
                        }
                        if (by2 == 37) {
                            if (null != object) {
                                object[n9] = 37;
                            }
                            ++n9;
                            if (null != object) {
                                object[n9] = 48;
                            }
                            ++n9;
                            continue;
                        }
                        if (by2 == 127) {
                            if (null != object) {
                                object[n9] = 37;
                            }
                            ++n9;
                            if (null != object) {
                                object[n9] = 53;
                            }
                            ++n9;
                            continue;
                        }
                        if (null != object) {
                            object[n9] = by2;
                        }
                        ++n9;
                        continue;
                    }
                    switch (by2) {
                        case 83: {
                            break;
                        }
                        case 65: {
                            if (null != object) {
                                object[n9] = 37;
                            }
                            ++n9;
                            if (null != object) {
                                object[n9] = 54;
                            }
                            ++n9;
                            break;
                        }
                        case 66: {
                            if (null != object) {
                                object[n9] = 37;
                            }
                            ++n9;
                            if (null != object) {
                                object[n9] = 55;
                            }
                            ++n9;
                            break;
                        }
                        case 67: {
                            if (null != object) {
                                object[n9] = 37;
                            }
                            ++n9;
                            if (null != object) {
                                object[n9] = 56;
                            }
                            ++n9;
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: {
                            if (null != object) {
                                object[n9] = 37;
                            }
                            ++n9;
                            if (null != object) {
                                object[n9] = by2;
                            }
                            ++n9;
                            break;
                        }
                        case 123: {
                            if (null != object) {
                                object[n9] = 123;
                            }
                            ++n9;
                            break;
                        }
                        default: {
                            throw new JposException(106);
                        }
                    }
                    by = 0;
                }
                if (null != object) continue;
                object = new byte[n9];
                n9 = 0;
            }
            object2 = object;
        } else if (101 == n) {
            if (((byte[])object2).length != 11 && ((byte[])object2).length != 12) {
                throw new JposException(106, "This request failed because UPC-A barcodes require 11 or 12 data digits to be specified.");
            }
            n11 = 49;
            for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                if (object2[n8] >= 48 && object2[n8] <= 57) continue;
                throw new JposException(106, "This request failed because UPC-A barcodes require all data digits to be between '0' and '9'.");
            }
            object = this.calcBarCodeWidthOfFixedModule(n3, 95);
            n3 = ((BarcodeWidth)object).getDotWidth();
            n12 = ((BarcodeWidth)object).getWidthCode();
        } else if (102 == n) {
            if (((byte[])object2).length != 11 && ((byte[])object2).length != 12) {
                throw new JposException(106, "This request failed because UPC-E barcodes require 11 or 12 data digits to be specified.");
            }
            n11 = 48;
            for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                if (object2[n8] >= 48 && object2[n8] <= 57) continue;
                throw new JposException(106, "This request failed because UPC-E barcodes require all data digits to be between '0' and '9'.");
            }
            object = this.calcBarCodeWidthOfFixedModule(n3, 51);
            n3 = ((BarcodeWidth)object).getDotWidth();
            n12 = ((BarcodeWidth)object).getWidthCode();
        } else if (103 == n) {
            if (((byte[])object2).length != 7 && ((byte[])object2).length != 8) {
                throw new JposException(106, "This request failed because JAN8 barcodes require 7 or 8 data digits to be specified.");
            }
            n11 = 50;
            for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                if (object2[n8] >= 48 && object2[n8] <= 57) continue;
                throw new JposException(106, "This request failed because JAN8 barcodes require all data digits to be between '0' and '9'.");
            }
            object = this.calcBarCodeWidthOfFixedModule(n3, 67);
            n3 = ((BarcodeWidth)object).getDotWidth();
            n12 = ((BarcodeWidth)object).getWidthCode();
        } else if (104 == n) {
            if (((byte[])object2).length != 12 && ((byte[])object2).length != 13) {
                throw new JposException(106, "This request failed because JAN13 barcodes require 12 or 13 data digits to be specified.");
            }
            n11 = 51;
            for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                if (object2[n8] >= 48 && object2[n8] <= 57) continue;
                throw new JposException(106, "This request failed because JAN13 barcodes require all data digits to be between '0' and '9'.");
            }
            object = this.calcBarCodeWidthOfFixedModule(n3, 95);
            n3 = ((BarcodeWidth)object).getDotWidth();
            n12 = ((BarcodeWidth)object).getWidthCode();
        } else if (106 == n) {
            if (((byte[])object2).length < 1 || ((byte[])object2).length > 255) {
                throw new JposException(106, "This request failed because ITF barcodes require between 1 and 255 data digits to be specified.");
            }
            n11 = 53;
            n7 = 4;
            n6 = 0;
            for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                if (object2[n8] < 48 || object2[n8] > 57) {
                    throw new JposException(106, "This request failed because ITF barcodes require all data digits to be between '0' and '9'.");
                }
                n7 += 3;
                n6 += 2;
            }
            if (((byte[])object2).length % 2 != 0) {
                n7 += 3;
                n6 += 2;
            }
            if (n3 < (n7 += 2) * 2 + ++n6 * 5) {
                n3 = n7 * 2 + n6 * 4;
                n12 = 52;
            } else if (n3 < n7 * 2 + n6 * 6) {
                n3 = n7 * 2 + n6 * 5;
                n12 = 49;
            } else if (n3 < n7 * 3 + n6 * 9) {
                n3 = n7 * 2 + n6 * 6;
                n12 = 55;
            } else if (n3 < n7 * 4 + n6 * 8) {
                n3 = n7 * 3 + n6 * 9;
                n12 = 56;
            } else if (n3 < n7 * 4 + n6 * 10) {
                n3 = n7 * 4 + n6 * 8;
                n12 = 53;
            } else if (n3 < n7 * 4 + n6 * 12) {
                n3 = n7 * 4 + n6 * 10;
                n12 = 50;
            } else if (n3 < n7 * 6 + n6 * 12) {
                n3 = n7 * 4 + n6 * 12;
                n12 = 57;
            } else if (n3 < n7 * 6 + n6 * 15) {
                n3 = n7 * 6 + n6 * 12;
                n12 = 54;
            } else {
                n3 = n7 * 6 + n6 * 15;
                n12 = 51;
            }
        } else if (107 == n) {
            if (((byte[])object2).length < 1 || ((byte[])object2).length > 255) {
                throw new JposException(106, "This request failed because CodeBar-A barcodes require between 1 and 255 data digits to be specified.");
            }
            n11 = 56;
            n7 = 0;
            n6 = 0;
            block39: for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                if (object2[n8] >= 48 && object2[n8] <= 57) {
                    n7 += 6;
                    n6 += 2;
                    continue;
                }
                if (object2[n8] >= 65 && object2[n8] <= 68) {
                    n7 += 5;
                    n6 += 3;
                    continue;
                }
                if (object2[n8] >= 97 && object2[n8] <= 100) {
                    n7 += 5;
                    n6 += 3;
                    continue;
                }
                switch (object2[n8]) {
                    case 36: {
                        n7 += 6;
                        n6 += 2;
                        continue block39;
                    }
                    case 43: {
                        n7 += 5;
                        n6 += 3;
                        continue block39;
                    }
                    case 45: {
                        n7 += 6;
                        n6 += 2;
                        continue block39;
                    }
                    case 46: {
                        n7 += 5;
                        n6 += 3;
                        continue block39;
                    }
                    case 47: {
                        n7 += 5;
                        n6 += 3;
                        continue block39;
                    }
                    case 58: {
                        n7 += 5;
                        n6 += 3;
                        continue block39;
                    }
                    default: {
                        throw new JposException(106, "This request failed because CodeBar-A barcodes do not support 1 or more of the specified data digits.");
                    }
                }
            }
            object = this.calcBarCodeWidthOfDualModule(n3, --n7, n6);
            n3 = ((BarcodeWidth)object).getDotWidth();
            n12 = ((BarcodeWidth)object).getWidthCode();
        } else if (108 == n) {
            if (((byte[])object2).length < 1 || ((byte[])object2).length > 255) {
                throw new JposException(106, "This request failed because Code39 barcodes require between 1 and 255 data digits to be specified.");
            }
            n11 = 52;
            n7 = 7;
            n6 = 3;
            for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                if (!(object2[n8] >= 48 && object2[n8] <= 57 || object2[n8] >= 65 && object2[n8] <= 90)) {
                    switch (object2[n8]) {
                        case 32: {
                            break;
                        }
                        case 36: {
                            break;
                        }
                        case 37: {
                            break;
                        }
                        case 43: {
                            break;
                        }
                        case 45: {
                            break;
                        }
                        case 46: {
                            break;
                        }
                        case 47: {
                            break;
                        }
                        default: {
                            throw new JposException(106, "This request failed because Code39 barcodes do not support 1 or more of the specified data digits.");
                        }
                    }
                }
                n7 += 7;
                n6 += 3;
            }
            object = this.calcBarCodeWidthOfDualModule(n3, n7 += 7, n6 += 3);
            n3 = ((BarcodeWidth)object).getDotWidth();
            n12 = ((BarcodeWidth)object).getWidthCode();
        } else if (109 == n) {
            if (((byte[])object2).length < 1 || ((byte[])object2).length > 255) {
                throw new JposException(106, "This request failed because Code93 barcodes require between 1 and 255 data digits to be specified.");
            }
            n11 = 55;
            object = null;
            n9 = 0;
            n7 = 9;
            for (int i = 0; i < 2; ++i) {
                for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                    by = object2[n8];
                    if (by < 0 || by > 127) {
                        throw new JposException(106);
                    }
                    if (i == 0) {
                        n7 += 9;
                    }
                    if (!(by == 32 || by >= 36 && by <= 37 || by == 43 || by >= 45 && by <= 47 || by >= 48 && by <= 57 || by >= 65 && by <= 90 || i != 0)) {
                        n7 += 9;
                    }
                    if (by >= 0 && by <= 31) {
                        if (null != object) {
                            object[n9] = 37;
                        }
                        ++n9;
                        if (null != object) {
                            object[n9] = 64;
                        }
                        ++n9;
                        if (null != object) {
                            object[n9] = by;
                        }
                        ++n9;
                        continue;
                    }
                    if (by == 37) {
                        if (null != object) {
                            object[n9] = 37;
                        }
                        ++n9;
                        if (null != object) {
                            object[n9] = 48;
                        }
                        ++n9;
                        continue;
                    }
                    if (by == 127) {
                        if (null != object) {
                            object[n9] = 37;
                        }
                        ++n9;
                        if (null != object) {
                            object[n9] = 53;
                        }
                        ++n9;
                        continue;
                    }
                    if (null != object) {
                        object[n9] = by;
                    }
                    ++n9;
                }
                if (null != object) continue;
                object = new byte[n9];
                n9 = 0;
            }
            n7 += 9;
            n7 += 9;
            object2 = object;
            BarcodeWidth barcodeWidth = this.calcBarCodeWidthOfFixedModule(n3, n7 += 10);
            n3 = barcodeWidth.getDotWidth();
            n12 = barcodeWidth.getWidthCode();
        } else if (204 != n && 201 != n) {
            throw new JposException(106, "This request failed because the specified symbology is not supported.");
        }
        if (1 == this.getRotateSpecial()) {
            arrayList.add(new byte[]{18});
        } else {
            arrayList.add(new byte[]{15});
        }
        this.addArrayListElementsLast(this.initializeCommand(), arrayList);
        if (0 <= n4) {
            arrayList.add(new byte[]{27, 29, 65, (byte)(n4 % 256), (byte)(n4 / 256)});
        } else if (n4 == -1) {
            arrayList.add(new byte[]{27, 29, 97, 0});
        } else if (n4 == -2) {
            arrayList.add(new byte[]{27, 29, 97, 1});
        } else if (n4 == -3) {
            arrayList.add(new byte[]{27, 29, 97, 2});
        }
        switch (n) {
            case 201: {
                byArray = new byte[]{27, 29, 120, 83, 48, 1, (byte)this.getPpdf417Line(), (byte)this.getPpdf417Column()};
                arrayList.add(byArray);
                byArray = new byte[]{27, 29, 120, 83, 49, (byte)this.getPpdf417Ecc()};
                arrayList.add(byArray);
                byArray = new byte[]{27, 29, 120, 83, 50, (byte)this.getPpdf417ModuleXdim()};
                arrayList.add(byArray);
                byArray = new byte[]{27, 29, 120, 83, 51, (byte)this.getPpdf417Aspect()};
                arrayList.add(byArray);
                byArray = new byte[6 + ((byte[])object2).length + 1];
                int n13 = ((byte[])object2).length % 256;
                n9 = ((byte[])object2).length / 256;
                byArray[0] = 27;
                byArray[1] = 29;
                byArray[2] = 120;
                byArray[3] = 68;
                byArray[4] = (byte)n13;
                byArray[5] = (byte)n9;
                for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                    byArray[6 + n8] = object2[n8];
                }
                arrayList.add(byArray);
                byArray = new byte[]{27, 29, 120, 80};
                break;
            }
            case 204: {
                byArray = new byte[]{27, 29, 121, 83, 48, (byte)this.getQrCodeModel()};
                arrayList.add(byArray);
                byArray = new byte[]{27, 29, 121, 83, 49, (byte)this.getQrCodeEcc()};
                arrayList.add(byArray);
                byArray = new byte[]{27, 29, 121, 83, 50, (byte)this.getQrCodeCellSize()};
                arrayList.add(byArray);
                byArray = new byte[8 + ((byte[])object2).length + 1];
                int n14 = ((byte[])object2).length % 256;
                n9 = ((byte[])object2).length / 256;
                byArray[0] = 27;
                byArray[1] = 29;
                byArray[2] = 121;
                byArray[3] = 68;
                byArray[4] = 49;
                byArray[5] = 0;
                byArray[6] = (byte)n14;
                byArray[7] = (byte)n9;
                for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                    byArray[8 + n8] = object2[n8];
                }
                arrayList.add(byArray);
                byArray = new byte[]{27, 29, 121, 80};
                break;
            }
            default: {
                byArray = new byte[6 + ((byte[])object2).length + 1];
                byArray[0] = 27;
                byArray[1] = 98;
                byArray[2] = n11;
                byArray[3] = n10;
                byArray[4] = n12;
                byArray[5] = (byte)n2;
                for (n8 = 0; n8 < ((byte[])object2).length; ++n8) {
                    byArray[6 + n8] = object2[n8];
                }
                byArray[6 + n8] = 30;
            }
        }
        arrayList.add(byArray);
        arrayList.add(new byte[]{27, 29, 97, 0});
        arrayList.add(new byte[]{27, 29, 65, 0, 0});
        return arrayList;
    }

    @Override
    public byte[] paperCutCommand(int n, boolean bl, boolean bl2) throws JposException {
        byte[] byArray = new byte[]{27, 100, 0};
        if (100 < n) {
            byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 2) : 0;
        } else {
            if (0 > n) {
                throw new JposException(106, "This request is illegal");
            }
            if (100 == n) {
                byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 2) : 0;
            } else if (0 == n) {
                if (bl) {
                    if (!this.m_capRecPartialCut && !this.m_capRecFullCut) {
                        byArray[2] = 116;
                    } else {
                        byArray[1] = 97;
                        byArray[2] = 1 > this.m_printerFont.getRecLinesToPaperCut() ? 1 : (127 < this.m_printerFont.getRecLinesToPaperCut() ? 127 : (byte)this.m_printerFont.getRecLinesToPaperCut());
                    }
                }
            } else {
                byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 3) : 1;
            }
        }
        return byArray;
    }

    @Override
    public byte[] markFeedCommand(int n) throws JposException {
        switch (n) {
            case 1: {
                return new byte[]{27, 100, 116};
            }
            case 8: {
                return new byte[]{12};
            }
        }
        throw new JposException(106, "This request failed because the specified type is not supported.");
    }

    @Override
    protected void multipleHeightSetting(int n, boolean bl) throws JposException {
        if (1 > n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and print with the normal height.");
            }
            this.m_multipleHeightCommand = 0;
        } else if (6 < n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and print with the height scaled 6 times the normal size.");
            }
            this.m_multipleHeightCommand = (byte)5;
        } else {
            this.m_multipleHeightCommand = (byte)(n - 1);
        }
    }

    @Override
    protected void multipleWidthSetting(int n, boolean bl) throws JposException {
        if (1 > n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to normal.");
            }
            this.m_multipleWidthCommand = 0;
        } else if (6 < n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to 6 width.");
            }
            this.m_multipleWidthCommand = (byte)5;
        } else {
            this.m_multipleWidthCommand = (byte)(n - 1);
        }
    }

    @Override
    protected byte[] multipleHeightAndWidthCommand() throws JposException {
        return new byte[]{27, 87, this.m_multipleWidthCommand, 27, 104, this.m_multipleHeightCommand};
    }

    @Override
    protected byte[] feedUnitsCommand(int n, boolean bl) throws JposException {
        int n2 = this.m_mapMode.mapModeToDotHeight(n);
        n2 = 0 != n2 % 2 ? n2 / 2 + 1 : (n2 /= 2);
        if (1 > n2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 1 dot.");
            }
            n2 = 1;
        } else if (255 < n2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 255 dots.");
            }
            n2 = 255;
        }
        return new byte[]{27, 74, (byte)n2};
    }

    @Override
    protected byte[] feedReverseCommand(int n, boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106, "This request failed because this request is not supported this print station.");
        }
        return null;
    }

    @Override
    protected byte[] nvBitImageCommand(int n) {
        if (this.m_isStarPRNT) {
            int n2 = n / 10 + 48;
            int n3 = n % 10 + 48;
            return new byte[]{27, 29, 56, 76, 6, 0, 0, 0, 48, 69, (byte)n2, (byte)n3, 1, 1};
        }
        return new byte[]{27, 28, 112, (byte)n, 48};
    }

    @Override
    public List bitmapCommand(Image image, int n, int n2, int n3, int n4) throws JposException {
        int n5 = 0;
        Object var7_7 = null;
        List list = null;
        list = this.initializeCommand();
        try {
            if (n != -11) {
                image = new ImageIcon(image.getScaledInstance(n, -1, 1)).getImage();
            }
            n = image.getWidth(null);
            n5 = image.getHeight(null);
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        if (n <= 0) {
            throw new JposException(106, "This request failed because the bitmap width is 0.");
        }
        if (n > this.m_printerFont.getLineWidthDot()) {
            throw new JposException(114, 206);
        }
        if (0 > this.m_printerFont.getLineWidthDot() - n2 - n) {
            throw new JposException(106, "This request failed because the aligment parameter is not valid.");
        }
        if (n2 == -1) {
            n2 = 0;
        } else if (n2 == -2) {
            n2 = (this.m_printerFont.getLineWidthDot() - n) / 2;
        } else if (n2 == -3) {
            n2 = this.m_printerFont.getLineWidthDot() - n;
        }
        if (n5 <= 0) {
            throw new JposException(106, "This request failed because the bitmap height is 0.");
        }
        try {
            Object object;
            if (259 == n3) {
                object = new byte[]{18};
                list.add(object);
            }
            object = new BitmapConverter(image, n3, n4);
            if (n > 1024) {
                n = 1024;
            }
            boolean bl = false;
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                int n7;
                byte[] byArray = new byte[4 + n * 3];
                byArray[0] = 27;
                byArray[1] = 88;
                byArray[2] = (byte)(n % 256);
                byArray[3] = (byte)(n / 256);
                int n8 = 4;
                int n9 = -1;
                int n10 = 24;
                if (n5 - i < 24) {
                    n10 = n5 - i;
                }
                for (n7 = n - 1; n7 >= 0; --n7) {
                    if (!((BitmapConverter)object).isPixelBlack(n7, i)) continue;
                    n9 = n7;
                    break;
                }
                if (n9 == -1) {
                    ++n6;
                    continue;
                }
                for (n7 = 0; n7 < n; ++n7) {
                    int n11 = (n10 + 7) / 8;
                    for (int j = 0; j < n11; ++j) {
                        int n12 = 0;
                        int n13 = 8;
                        if (j == n11 - 1) {
                            n13 = n10 / 8 == 0 ? 8 : n10 - (n11 - 1) * 8;
                        }
                        for (int k = 0; k < n13; ++k) {
                            n12 = (byte)(n12 << 1);
                            if (!((BitmapConverter)object).isPixelBlack(n7, i + j * 8 + k)) continue;
                            n12 = (byte)(n12 | 1);
                        }
                        if ((n12 = (int)((byte)(n12 << 8 - n13))) != 0 && n9 < n7) {
                            n9 = n7;
                        }
                        byArray[n8++] = n12;
                    }
                    n8 += 3 - n11;
                }
                n7 = 1;
                if (n7 != 0 && ++n9 < n) {
                    byArray[2] = (byte)(n9 % 256);
                    byArray[3] = (byte)(n9 / 256);
                    System.arraycopy(byArray, 4, byArray, 4, n9 * 3);
                    n8 = 4 + n9 * 3;
                }
                while (n6 != 0) {
                    byte[] byArray2 = new byte[]{27, 73, -1};
                    if (n6 > 255) {
                        n6 -= 255;
                    } else {
                        byArray2[2] = (byte)n6;
                        n6 = 0;
                    }
                    list.add(byArray2);
                }
                if (n2 != 0) {
                    byte[] byArray3 = new byte[]{27, 29, 65, (byte)(n2 % 256), (byte)(n2 / 256)};
                    list.add(byArray3);
                }
                byte[] byArray4 = new byte[n8];
                System.arraycopy(byArray, 0, byArray4, 0, n8);
                list.add(byArray4);
                byte[] byArray5 = new byte[]{27, 73, (byte)n10};
                list.add(byArray5);
                i += n10 - 1;
            }
            while (n6 != 0) {
                byte[] byArray = new byte[]{27, 73, -1};
                if (n6 > 255) {
                    n6 -= 255;
                } else {
                    byArray[2] = (byte)n6;
                    n6 = 0;
                }
                list.add(byArray);
            }
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        return list;
    }

    public BarcodeWidth calcBarCodeWidthOfFixedModule(int n, int n2) {
        int n3 = 49;
        if (n < n2 * 3) {
            n = n2 * 2;
            n3 = 49;
        } else if (n < n2 * 4) {
            n = n2 * 3;
            n3 = 50;
        } else if (this.m_printResolution == PrintResolution.Resolution300dpi) {
            if (n < n2 * 5) {
                n = n2 * 4;
                n3 = 51;
            } else if (n < n2 * 6) {
                n = n2 * 5;
                n3 = 52;
            } else {
                n = n2 * 6;
                n3 = 53;
            }
        } else {
            n = n2 * 4;
            n3 = 51;
        }
        return new BarcodeWidth(n, (byte)n3);
    }

    public BarcodeWidth calcBarCodeWidthOfDualModule(int n, int n2, int n3) {
        int n4 = 55;
        if (n < n2 * 2 + n3 * 5) {
            n = n2 * 2 + n3 * 4;
            n4 = 55;
        } else if (n < n2 * 2 + n3 * 6) {
            n = n2 * 2 + n3 * 5;
            n4 = 52;
        } else if (n < n2 * 3 + n3 * 6) {
            n = n2 * 2 + n3 * 6;
            n4 = 49;
        } else if (n < n2 * 3 + n3 * 8) {
            n = n2 * 3 + n3 * 6;
            n4 = 56;
        } else if (n < n2 * 3 + n3 * 9) {
            n = n2 * 3 + n3 * 8;
            n4 = 53;
        } else if (n < n2 * 4 + n3 * 8) {
            n = n2 * 3 + n3 * 9;
            n4 = 50;
        } else if (n < n2 * 4 + n3 * 10) {
            n = n2 * 4 + n3 * 8;
            n4 = 57;
        } else if (n < n2 * 4 + n3 * 12) {
            n = n2 * 4 + n3 * 10;
            n4 = 54;
        } else if (this.m_printResolution == PrintResolution.Resolution300dpi) {
            if (n < n2 * 5 + n3 * 10) {
                n = n2 * 4 + n3 * 12;
                n4 = 51;
            } else if (n < n2 * 5 + n3 * 13) {
                n = n2 * 5 + n3 * 10;
                n4 = 67;
            } else if (n < n2 * 6 + n3 * 12) {
                n = n2 * 5 + n3 * 13;
                n4 = 66;
            } else if (n < n2 * 5 + n3 * 15) {
                n = n2 * 6 + n3 * 12;
                n4 = 70;
            } else if (n < n2 * 6 + n3 * 15) {
                n = n2 * 5 + n3 * 15;
                n4 = 65;
            } else if (n < n2 * 6 + n3 * 18) {
                n = n2 * 6 + n3 * 15;
                n4 = 69;
            } else {
                n = n2 * 6 + n3 * 18;
                n4 = 68;
            }
        } else {
            n = n2 * 4 + n3 * 12;
            n4 = 51;
        }
        return new BarcodeWidth(n, (byte)n4);
    }
}

